/*         			  This program is included to provide an example			  
 *                  of coding to a DECtalk-PC. It uses most of the
 *                  TSR calls. It is not intended to be functionally
 *                  or architecturally complete. For example it busy
 *                  waits most TSR calls which is not an efficient use
 *                 of the CPU's compute cycles.
 *
 */

#include "dttsr.h"
#include "dtdemp.h"
#include "string.h"
struct dectalk_char_buff  dtbuf;


int   dtport =3;
int insquare =0;
char findex[]=" [:i m 00 ][_ <20,>][:sync]";
char   intro[]="DECtalk Demonstration program. \nTo run demonstration program, press enter, \
to quit, press any other key. \n ";
char last[]="[:i m 999 _][:sync] ";
char   tmps[]="If you would like the commands spoken, press enter. ";
char   tmp1[]="If you would like the commands not to be spoken, press the space-bar. ";
char   tmp2[]="For list of commands, type question-mark. ";
char   warnt[]="Warning! The p, or pause command must be followed by a c, or continue command. ";
char   tmp3[]="Typing demonstration, type an * to exit. ";
char   texit[]="\n Exiting typing demonstration. \n";
char   sil[]= "[:phon arpa on][:i m 1000 ][:sync]";
char   rcvt[]="I have recieved from the dectalk,[:sync] [:sa le]\013 ";
char   vst[]="Volume setting incorrect, ignoring request. ";
char   edt[]="Type an * to end input, type up to 500 characters of text! \n";
char   lot[]="Input name of file to be sent to dectalk. ";
char   nopnt[]="Couldn't find or open file. \n";
char   sayl[]="[:sa le][:ra 400][:phon arpa off]";
char   invs[]="Input volume setting:";
char   backs[]="backspace\013";
char   aborts[]="Type any key to abort file send. ";
char   space[]="space\013";
char   dels[]="delete\013";
char   clist[]="To run a typing demonstration, type t.\013 \n\
To quit, type q. \n\
To enter text string, type e. \n\
To repeat text entered, type r. \n\
For volume up, type u. \n\
For volume down, type d. \n\
To set volume to a value between 0 and 100, type v. \n\
To see last index processed type i. \n\
To speak a canned message, type s. \n\
To pause speaking, type p. \n\
To flush speech, type f. \n\
To continue speaking, type c. \n\
To get a string of characters from the dectalk, type g. \n\
To copy a file to the dectalk, type l. \n";
char deft[]="Incorrect command, please type a ? for a list of commands. ";
char reset[]="[:np] [:sa c][:phon arpa on][:pu so][:ra 220] \013";
int quit,outi;
int icnt=1;
int nindx=1;
int isent = 1;
int gotsq=0;
int phonemode = 0;
int phmode =0;
int parse;
int inphodur=0;
int inpdur=0;
char outb[2000];
char testb[]="[:nb]how are you today[:nh]? The quick brown fox jumped over the\
lazy dog. And the dish ran away with the spoon.";
static unsigned char tmp[253];
static unsigned char outj[1024];


union _REGS  regs;



void main(void)
{
	int inp;
	int count,done=0;
	char cfbuf[30];
	unsigned char inchar;
	char wtype[]="Setting rate to 450 words per minute[:ra 450]. ";
	char reply[80]="ESCP0;31;44zESC\\";
	char sayc[]="[:say clause]\013";
	char flsh[]="[:fl all]\013 ";
	char enable[]="[:en ]";
	FILE *fp;
	char dcharbuf[256];
	char dtinbuf[500];
	char cancharbuf[]="[:nh]Hello, I'm DECtalk, the state of the art in text to speech synthesis[:np]. \n";
	char tbuf[]="[:np]1,[:nb]2,[:np]3,[:nb]4,[:np]5,[:np]1,[:nb]2,[:np]3,[:nb]4,[:np]5, ";
	int go,i;
	int tc=9;
	int vol;
	int spoken=0;
	
	flush();    /*Flush buffer in case anything was left inside the DECtalk */
	sendb(reset,sizeof(reset));
	putchar('\n');
	go=1;
   io_prior();
	do{
	sendb(tmps,sizeof(tmps));     /*Is a spoken setup desired */
	sendb(tmp1,sizeof(tmp1));
	 inp =  _getch();
	 if (inp=='\r')
	    spoken=1;
	 } while(!(inp ==' ' || inp =='\r'));
	printf("Dectalk demonstration program. Type ? for list of commands.\n");
	if (spoken) sendb(tmp2,sizeof(tmp2));
	if (spoken) sendb(warnt,sizeof(warnt));
	 printf("\n>");
	 while (go){
	   inp = tolower( _getch());                 /* Get a command character from the keyboard*/
	   putchar(inp);
 	   putchar('\n');
	   switch (inp)                        /* And based on it decide what to do (Case sensitive)*/
	    {
	    case 't': /* Typing demo.*/
		flush();                  /*Flush out what ever is lying around */
		printf("%s\n",tmp3);
		snd_string(); /* Send string using send_char*/
		do{
		  inchar = (char)_getch();
		  flush_char(inchar);
		  putchar(inchar);
		  }while(inchar != '*');
		 sendb(reset,sizeof(reset));
		 printf("%s,\n",texit);
		 if (spoken) sendb(texit,sizeof(texit));
		 break;
	case 'i':
		for (i=4;i;i--)
			{
	  	count=get_index();
		if (count == -1 ) 
		    printf("No new index has been seen.\n");
		else
		    printf("The last index was number %d \n",count);
			}
		    break;
	case 'p':
		 printf("Warning! This command must be followed by a \"c\" continue command!\n");

		 stopit();      /*stop speaking --PAUSE----*/

		 break;

	case 'g':
			/* Get a string of characters from the dectalk-one at a time*/
	
		 i=0;
		 dtinbuf[0]=(int)'\0';
		 while ((dtinbuf[i] =  gtdch()) !=0){
			
		    if (dtinbuf[i] == '\033')        /*if an esc display it*/
			{
			dtinbuf[i++] = (int)'E';
			dtinbuf[i++] = (int)'S';
			dtinbuf[i] = (int)'C';
			}
		    i++;
		    }
		 dtinbuf[i]=(int)'\0';
		 printf ("RECIEVED FROM DT %s \n",dtinbuf); /* Print characters recieved */
		 if (spoken){                   /*Esc will be spelled esc*/
		     sendb(rcvt,sizeof(rcvt));
		     for (i=0;dtinbuf[i];i++){
			if (dtinbuf[i] == '\b' || dtinbuf[i] == ' ' || dtinbuf[i] == '\177'){
			  sendb(sayc,sizeof(sayc)-1);           /* Say letter doesn't handle non-printing chracters*/
			  switch(dtinbuf[i]){                     /* So handle of few of them here*/
			    case '\b':{                        /*If space, backspace, or delete*/
			      sendb(backs,sizeof(backs)-1);      /* go into say clause mode and say them */
			      break;
			      }
			    case ' ':{
			      sendb(space,sizeof(space)-1);
			      break;
			      }
			    case '\177':{
			      sendb(dels,sizeof(dels)-1);
			      break;
			      }
			  }
			send_char(dtinbuf[i]);
			}
			else{
			send_char((char)dtinbuf[i]);
			if (dtinbuf[i] == '['){
			    send_char('[');
			    send_char(']');
			    }
			}
		     }
		 sendb(reset,sizeof(reset)-1);
		    }
		 break;

	case 'v':         /* Set the volume to a specific level */
		 if (spoken) flush();
		 printf("%s",invs);                       /* Prompt */
		 if (spoken) sendb(invs,sizeof(invs));
		 i=0;
		 while ((cfbuf[i] =  (char)_getch()) !='\r'){     /*Get input */
		    if (spoken) flush();                  /*Flush speech if spoken. */
		    putchar(cfbuf[i]);                    /* Echo input */
		    if (spoken) send_char(cfbuf[i]);      /* Audible echo */
		    send_char('\013');
		    i++;
		 }
		 cfbuf[i]='\0';
		  _cputs("\r\n");
		 vol=atoi(cfbuf);                         /* Convert to a number */
		 if ((vol > 100) || vol<0){                /* Is input in range? */
		    printf ("%s,%d\n",vst,vol);
		    if (spoken) sendb(vst,sizeof(vst));
		    break;
		    }
		set_vol(vol);                             /* Go set the volume. */
		break;

	case 'e':         /* Allow user to type in text, send to DECtalk */
			  /*  when a CR seen.*/
		if (spoken)flush();
		dcharbuf[0]='\0';
		printf ("%s\n",edt);
		if (spoken) sendb(edt,sizeof(edt));       /* Prompt */
		 _cputs("Input text:\n\r");
		tc=0;
		sendb(sayl,sizeof(sayl)-1);
		while ((dcharbuf[tc] = (char) _getch()) != '*'){   /*Get input*/
		    if (dcharbuf[tc] == '\b' || dcharbuf[tc] == ' ' || dcharbuf[tc] == '\177'){
			sendb(sayc,sizeof(sayc)-1);
			switch(dcharbuf[tc]){                    /*Echo some characters not said */
			  case '\b':{                            /*not said by sayletter. */
			    sendb(backs,sizeof(backs)-1);
			    break;
			    }
			  case ' ':{
			    sendb(space,sizeof(space)-1);
			    break;
			    }
			  case '\177':{
			    sendb(dels,sizeof(dels)-1);
			    break;
			    }
			  }
			sendb(sayl,sizeof(sayl)-1);
			}
		    else
			  send_char((char)dcharbuf[tc]);
		    if (dcharbuf[tc] == '['){
			send_char('[');
			send_char(']');
			}
		    putchar(dcharbuf[tc++]);
		    if (dcharbuf[tc-1] == '\010'){
			putchar(' '); /* print space */
			putchar('\010'); /*and back up again*/
			tc=tc-2;
			}
		    if (dcharbuf[tc-1] == '\r'){
			dcharbuf[tc-1] = ' ';
			putchar('\n');
			putchar('\r');
			}
		    }
		dcharbuf[tc++]='\013';
		dcharbuf[tc]='\0';
		 _cputs("\r\n");
		sendb(reset,sizeof(reset)-1);
		sendb(dcharbuf,tc);
		break;
	case 'r' :
		sendb(dcharbuf,tc);
	case '\n':
		  break;

	case 'u':  /* Increment the volume louder by 1.*/
		  up_vol();
		  break;

	case 'd'  : /* Decrease the volume by 1.*/
		dwn_vol();
		break;

	case 'l'        : /* Send a file to the DECtalk*/
		flush();
		printf ("%s\n",lot);                       /* Prompt */
		if (spoken) sendb(lot,sizeof(lot));
		sendb(sayl,sizeof(sayl)-1);
		i=0;
		phmode=0;		/*intialize things in case left in odd state*/
		phonemode=0;
		insquare=0;
		inphodur=0;
		inpdur=0;
		nindx=1;
		while ((cfbuf[i] = (char) _getch()) != '\r'){          /* Get file name-with char echo and basic editing */
		    if (cfbuf[i] == '\b' || cfbuf[i] == ' ' || cfbuf[i] == '\177'){
			sendb(sayc,sizeof(sayc)-1);     /* Enter say clause mode */
			switch(cfbuf[i])               /* Speak non-printing char's of interest */
			  {
			  case '\b':{
			    sendb(backs,sizeof(backs)-1);
			    break;
			    }
			  case ' ':{
			    sendb(space,sizeof(space)-1);
			    break;
			    }
			  case '\127':{
			    sendb(dels,sizeof(dels)-1);
			    break;
			    };
			  }
			sendb(sayl,sizeof(sayl)-1);     /*Enter say letter mode */
			}
		    else
			send_char((char)cfbuf[i]);     /* Regular char just send it */
		    if (cfbuf[i] == '['){             /* Special case for command introducer in say letter mode */
			send_char('[');
			send_char(']');
			}
		    putchar(cfbuf[i++]);
		    if (cfbuf[i-1] == '\010'){
			putchar(' ');                /* print space */
			putchar('\010');             /* and back up again*/
			i=i-2;
			}

		 }
		cfbuf[i]='\0';
		 _cputs("\r\n");
		sendb(reset,sizeof(reset));

		if ((fp=fopen (cfbuf,"r")) == 0){              /* Try to open file */
		    printf("%s\n",nopnt);

		    break;
		    }

		while ((dtinbuf[i] = gtdch()) !=0);
		sendfil(fp);                                     /* Send the file to the screen and the DECtalk */
		_fcloseall();
		sendb(reset,sizeof(reset));
		break;

	case 'c'        : /* Resume speaking after a stop.*/
		resume();
		break;
	case 'f'        : /* Stop speaking and FLUSH */
		sendb (testb,sizeof(testb));
		flush();   /*asynchronously flush the dectalk */
	  /*	sendb(flsh,sizeof(flsh)) synchronously flush the text*/
		break;                    /*stream pipe*/


	case 's':    /* Send a buffer of data   */
		sendb(cancharbuf,sizeof(cancharbuf));
		break;

	case 'q':      /* QUIT this program*/
		go=0;
		break;
	case '?':
		printf("%s\n",clist);
		if (spoken) sendb(clist,sizeof(clist));
		break;
	default :
		printf ("INCORRECT COMMAND-TYPE ? FOR A LIST OF COMMANDS\n");
		if (spoken) sendb(deft,sizeof(deft));
	}
	 _cputs("\n\r>");
 }
}
index()
{
int i,j;
char inds[]=" [:i m    ]  ";
char pindex[]="][:i m    ][ ";
char indx[5];
	if (icnt >= 110)
	icnt=1;
	_itoa(icnt,indx,10);
	inds[8]=' ';               /*initalize  */
	inds[9]=' ';               /*initalize  */
	if (phonemode)
		{
		for (j=7;indx[j-7];j++)  /*Paste index into blank index reply string */
	 		{
	 		pindex[j]=indx[j-7];
	 		}
		icnt++;
		for (i=0;13-i;i++)
	      {
	      outb[outi++]=pindex[i]; /*add index to output buffer*/
	      }

		}
	else
		{
		for (j=7;indx[j-7];j++)  /*Paste index into blank index reply string */
	 		{
	 		inds[j]=indx[j-7];
	 		}
		icnt++;
				for (i=0;13-i;i++)
	      {
	      outb[outi++]=inds[i]; /*add index to output buffer*/
	      }
		}
	return(1);
}

sendfil(struct _iobuf *ptr)
{
      int size,oldj,oi;
      int start,count=0;
      int lsaid,i,j=0;
      int jj=0;
      

    i=1;
    start=1;
    quit=0;
    icnt=1;
    oi=0;
    sendb(findex,sizeof(findex)); /*guarantee a first index gets inserted*/
    while((size = fread(tmp,1,250,ptr)) !=0  && quit == 0)   /*Read a buffer from the file */
	{
	if( _kbhit() !=0)             /*If a key is hit exit routine. */
	    {
	     flush();
	    _getch();
	    quit=1;
	    }
	oldj=0;

	for (j=0;(size-j);j++)    /* look for phrase to send   */
	    {
	    outj[oi++]=tmp[j];
		 if (tmp[j] == '[')parse=1;
		 if (parse && tmp[j] != ':')
			{
			parse =0;
			phmode=1;
			}
		 else
			{
			parse=0;
		   
			}
	    switch(tmp[j])       /*If so we could have a potential problem with */
		 	{                                  /* DECtalk waiting for a clause boundary. */
		 	case ',':
		 	case '?':
		 	case '!':
		 	case '.':
		  	if(tmp[j+1] == ' '||  tmp[j +1 ] == '\t'||  tmp[j+1] == '\n' || tmp[j+1] =='\00')
		   	{
			   count=0;
				j++;
				if (j >= 250)   /*If we're at the end, go get more */
			    	{		  
			    	j=249; /*set to size-1 to cause read after autoinc. */
			    	break;
			    	}
				/* what if duration with a punc mark in phonemic text */
   			if (phmode )
					{
		
					outj[oi++] = ' ';
					outj[oi++] = ' ';
						
					}	 
		
			
				if (!phmode)
					{
					outj[oi++]='\013';
					outj[oi++]=' ';
					}
				if (size <250 && oi >= size) /*insert end of file*/
					{
					outj[oi++]='\0';
					}
				if (sayit(oi,outj) == 0)return(0);
			 	if (phmode && tmp[j] == ']')
					{
					outj[oi++] = tmp[j];
					sayit(oi,outj);
					}
	
				lsaid=j;
				oi = 0;
				oldj = j;
		   	break;
		   	}
		 	default:
		  	count++;
		 }
    if (count > 160 && j >= 250) /*Force clause boundary by end of buffer*/
	      {		 
	      count = 0; /*reset count */

			/*Punt and force */
			if (sayit(size-j-lsaid, &tmp[lsaid]) == 0)return(0);      /* say entire buffer from lsaid. */
			sendb(sil,sizeof(sil));  /*guarantee mark gets out */
			oi=0; /*reset ouput buffer count */
			j=size-1; /* and set j ready to abort after increment*/

	     	}					  
	    tmp[size]='\0';
		 if (phmode && tmp[j] == ']')phmode=0;
		 if (phmode && tmp[j] == '<')inphodur=1;
		 if (inphodur && tmp[j] =='>')inphodur = 0;
	
	    }
	}
	return(1);
}

sayit(int bsize,unsigned char *outj)         /*send output buffer and return when bufer lower */
	{
	int j,temp,ltemp,i;
   int lindx=1;
	int abort=0;
   outi=0;
	for (j=0;bsize-j;j++)
	    {
	    outb[outi++]=outj[j]; /*copy to output buffer */
		 
	    if (outi > 1900)
			{
			printf("outbuf overflow aborting\n");
		  	exit(0);
			}
		 if (outj[j] >= 'A' && outj[j] <= 'z') isent=0;
		
		 if (phonemode && tmp[j] == '<')
			{
			inpdur = 1;
			}
		 if (gotsq == 1)
			{
			gotsq = 0;
			if (outj[j] == ':' )
				{
				insquare=1;
			
				}
				else
				{
				
				insquare = 0;
				phonemode = 1;
			   }
			}
		 if (outj[j] == '[' )
			{
			gotsq=1;
			
			}
		 if (insquare && outj[j] == ']') insquare=0;
		 if (phonemode && outj[j] == ']')
			{
			phonemode=0;
			}
		 if (!insquare && !inpdur )
			{
	      if ((outj[j] ==' ' || outj[j] == '/n') && isent != 1 )  /*and add in index */
		   	{
				outj[j] = (char)(128+icnt);
				index();
				isent = 1;
				}
    
			}
		 if (inpdur && tmp[j] =='>')inpdur = 0;
		 }
	 /* outb[outi]=' ';  */
	 sendb(outb,outi);
#ifdef DEBUG		 
  	 printf("   outb =%s",outb);
#endif						
	 for(i=0;bsize-1-i;i++)          /* is spoken, and before printing, remove any cntrl-k chars */
	    {
	    if (outj[i]=='\013')         /* from buffer for better printing */
		  {
		  outj[i]=' ';
		  }

	    if ((unsigned int)outj[i] >= 128)
			{
			lindx = outj[i]&0x7F;
#ifdef DEBUG
		   printf ("lindx at strip %d ",lindx); /*debug indexing printout*/
#endif
			outj[i]=' ';


			}
	    if (outj[i] =='\10')   putchar('\n');
	    else  putchar(outj[i]);
	    if (outj[i+1] == '\0')
			{
			return(1);  /*end of file quit.*/
			}
	  
	    if((unsigned int)outj[i+1] >= 128 )
		
			/*If next thing is another index-check for last*/

		 	{

/*			printf ("nindx= %d lindx = %d",nindx,lindx);		debug printou*/

		 	if (nindx < lindx || (lindx < 8 && nindx >= 108))   /*    Do we need to wait for an index?*/
		 		{
		 		nindx= -1;
		 		temp = -1;

		 		abort=0;
		 		if (insquare != 1)
					{
		 			do
						{
		  				nindx=get_index();
						if ((lindx >= 108 && nindx <=10) && nindx != -1 )	 /* handle wrap around*/
							{										 /* knowing some get missed*/
							nindx  = lindx;
							}
						if (nindx != -1)
							{
							ltemp=nindx;
							}
		  			  
						/* Check to see if we missed one */
						/* and got ahead of ourselves so we need to process more text*/
						if (nindx == lindx+1) break;
						/* indexs not set equal so we can print slightly ahead and allows some slop in checking times*/
		  				}while (nindx == -1 || nindx < (lindx-1) );
					}
		 		}
			}
	    }
   return(1);
}

snd_string()
{
	    int i;
	    char buf[]= "Setting rate to 450 words per minute[:np][:nv ][:ra 450]\013 ";
	for (i=0;buf[i];i++)
	  send_char(buf[i]);
	return(1);
}

sendb(unsigned char __far *thebuf,int count)
{
	struct  dectalk_char_buff   cb;
	struct  dectalk_char_buff   _far *cbp;
	

	cb.buff=thebuf;
	cb.count=count;
	cbp = &cb;

	do{
	RW.bx = FP_OFF(cbp);  /* put offset to char buff struct in bx */
	RW.dx = FP_SEG(cbp);  /*put segment in dx */
	RB.ah = DECTALK_ID;
	RB.al = SEND_BUFF;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while (regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
   return(RW.ax);

}


flushs()
{
	do{
	RB.ah = DECTALK_ID;
	RB.al = FLUSH_SPEECH;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY );
	if (regs.x.ax == TSR_FAILURE) printf ("TSR_FAILURE\n");
	return(1);
}
 

flush()
{
	do{
	RB.ah = DECTALK_ID;
	RB.al = FLUSH_TEXT;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY );
	return(1);
}


io_prior()
{
	do{
	RB.ah = DECTALK_ID;
	RB.al = IO_PRIORITY;
	RW.cx=1;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY );
	return(1);
}


get_index()
{
	do{
	RB.ah = DECTALK_ID;
	RB.al = LAST_INDEX;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY );
	if ( regs.x.ax == TSR_RETRY )
		return(-1);
	if ( regs.x.ax == TSR_FAILURE )
		printf("tsr get_index failed");

	return(regs.x.cx);
}




resume()
{       
	

	do{
	RB.ah = DECTALK_ID;
	RB.al = RESUME_OUTPUT;
	RW.si = 0;
	_int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	return(RW.ax);

}

stopit()

{
	do{
	RB.ah = DECTALK_ID;
	RB.al = PAUSE_OUTPUT;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	return(RW.ax);
}

flush_char(unsigned char fchar)
{

	RB.ah = DECTALK_ID;
	RB.al = 0x2A;
	RB.bl = fchar;
	RW.si = 0;
	_int86(0x2f, &regs, &regs);
	return(1);
}

gt_stat(int dtport)
{
	do{
	RB.ah = _COM_STATUS;
	RB.al = 0;
	RW.dx = dtport;
	RW.si = 0;
	_int86(0x14, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	return(RW.ax);
}

unsigned char gtdch()
{       
	do{
	RB.ah = DECTALK_ID;
	RB.al = GET_CHAR;
	RW.si = 0;
	_int86(0x2f, &regs, &regs);
	}while(regs.x.ax != TSR_SUCCESS && (regs.x.dx & 0x2)); 
	if (regs.x.ax == TSR_RETRY)
      RW.bx = 0;
	return((char)RW.bx);
}

send_char(unsigned char schar)                                                         
{       
	

	do {
	RB.ah = DECTALK_ID;
	RB.al = SEND_CHAR;
	RB.bl = schar;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while( regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	return(RW.ax);

}
up_vol()

{       
	

	do {
	RB.ah = DECTALK_ID;
	RB.al = VOLUME_UP;
	RB.bl=1;
	RB.dl=0;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	return(RW.ax);

} 
dwn_vol()

{       
	

	do{
	RB.ah = DECTALK_ID;
	RB.al = VOLUME_DOWN;
	RB.bl=1;
	RB.dl=1;
	RW.si = 0;
	 _int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);

	return(RW.ax);
}
set_vol(int vol)
{       
	

	do{
	RB.ah = DECTALK_ID;
	RB.al = VOLUME_SET;
	RW.bx = vol;
	RW.si = 0;
	_int86(0x2f, &regs, &regs);
	}while(regs.x.ax == TSR_BUSY || regs.x.ax == TSR_RETRY);
	printf("Setting the volume to %d\n.",vol);

	return(RW.ax);
}
